(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     95990,       2020]
NotebookOptionsPosition[     94756,       1992]
NotebookOutlinePosition[     95157,       2008]
CellTagsIndexPosition[     95114,       2005]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   SuperscriptBox["10", 
    RowBox[{"r", "+", 
     RowBox[{"radiusstep", "/", "2"}]}]], "-", 
   SuperscriptBox["10", 
    RowBox[{"r", "-", 
     RowBox[{"radiusstep", "/", "2"}]}]]}], "/.", 
  RowBox[{"r", "\[Rule]", 
   RowBox[{"Log10", "[", "radii", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SuperscriptBox["10", 
    RowBox[{"l", "+", 
     RowBox[{"lengthstep", "/", "2"}]}]], "-", 
   SuperscriptBox["10", 
    RowBox[{"l", "-", 
     RowBox[{"lengthstep", "/", "2"}]}]]}], "/.", 
  RowBox[{"l", "\[Rule]", 
   RowBox[{"Log10", "[", "lengths", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.914668461201038*^9, 3.914668499201144*^9}, {
  3.9146685445792227`*^9, 3.914668545690439*^9}, {3.914668700775641*^9, 
  3.914668724535521*^9}, {3.914668824250291*^9, 3.914668878035355*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"ed8a0803-0b0b-4290-9619-cc4a7cd89108"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.4605577132494343`", ",", "0.48226312956852446`", ",", 
   "0.5049914906435706`", ",", "0.5287910063756609`", ",", 
   "0.553712158728521`", ",", "0.5798078088075247`", ",", 
   "0.6071333089851976`", ",", "0.6357466203110071`", ",", 
   "0.6657084354545315`", ",", "0.6970823074427397`", ",", 
   "0.7299347844644863`", ",", "0.7643355510281467`", ",", 
   "0.800357575771784`", ",", "0.8380772662394484`", ",", 
   "0.8775746309517771`", ",", "0.9189334491148422`", ",", 
   "0.9622414483270276`", ",", "1.0075904906610766`", ",", 
   "1.0550767675158248`", ",", "1.1048010036510831`", ",", 
   "1.1568686708383353`", ",", "1.2113902115805217`", ",", 
   "1.2684812733753787`", ",", "1.3282629540193227`", ",", 
   "1.3908620584720488`", ",", "1.4564113678269202`", ",", 
   "1.5250499209574286`", ",", "1.5969233094372939`", ",", 
   "1.6721839863597125`", ",", "1.7509915897108073`", ",", 
   "1.8335132809832118`", ",", "1.9199240997479947`", ",", 
   "2.0104073349370495`", ",", "2.1051549136235153`", ",", 
   "2.2043678081248004`", ",", "2.3082564622918653`", ",", 
   "2.417041237888789`", ",", "2.530952882009636`", ",", "2.650233016523991`",
    ",", "2.7751346505893224`", ",", "2.9059227173173383`", ",", 
   "3.0428746357326304`", ",", "3.1862808992156175`", ",", 
   "3.336445691677966`", ",", "3.493687532777429`", ",", 
   "3.6583399535407466`", ",", "3.8307522038277284`", ",", 
   "4.011289993136913`", ",", "4.200336266324555`", ",", "4.398292015881964`",
    ",", "4.60557713249429`", ",", "4.822631295685127`", ",", 
   "5.049914906435603`", ",", "5.287910063756499`", ",", "5.537121587285085`",
    ",", "5.79807808807513`", ",", "6.071333089851834`", ",", 
   "6.3574662031099365`", ",", "6.657084354545191`", ",", 
   "6.970823074427216`", ",", "7.2993478446447`", ",", "7.643355510281282`", 
   ",", "8.00357575771767`", ",", "8.380772662394293`", ",", 
   "8.775746309517615`", ",", "9.189334491148202`", ",", "9.622414483270092`",
    ",", "10.075904906610532`", ",", "10.550767675158028`", ",", 
   "11.04801003651059`", ",", "11.568686708383098`", ",", 
   "12.113902115804933`", ",", "12.684812733753517`", ",", 
   "13.282629540192943`", ",", "13.908620584720154`", ",", 
   "14.564113678268882`", ",", "15.250499209573945`", ",", 
   "15.969233094372555`", ",", "16.721839863596756`", ",", 
   "17.509915897107703`", ",", "18.335132809831748`", ",", 
   "19.199240997479535`", ",", "20.104073349370026`", ",", 
   "21.051549136234655`", ",", "22.043678081247492`", ",", 
   "23.0825646229182`", ",", "24.170412378887363`", ",", 
   "25.309528820095807`", ",", "26.5023301652393`", ",", "27.75134650589257`",
    ",", "29.059227173172758`", ",", "30.428746357325622`", ",", 
   "31.862808992155465`", ",", "33.36445691677898`", ",", 
   "34.936875327773464`", ",", "36.583399535406784`", ",", 
   "38.307522038276375`", ",", "40.11289993136813`", ",", 
   "42.003362663244616`", ",", "43.982920158818615`", ",", 
   "46.0557713249425`", ",", "48.2263129568513`", ",", "50.499149064355834`", 
   ",", "52.87910063756499`", ",", "55.371215872850826`", ",", 
   "57.98078088075113`", ",", "60.71333089851828`", ",", "63.57466203109925`",
    ",", "66.57084354545191`", ",", "69.70823074427244`", ",", 
   "72.99347844644717`", ",", "76.43355510281276`", ",", "80.03575757717681`",
    ",", "83.80772662394293`", ",", "87.75746309517604`", ",", 
   "91.89334491148202`", ",", "96.22414483270086`", ",", 
   "100.75904906610504`", ",", "105.50767675158022`", ",", 
   "110.4801003651055`", ",", "115.68686708383075`", ",", 
   "121.13902115804922`", ",", "126.84812733753552`", ",", 
   "132.8262954019292`", ",", "139.08620584720165`", ",", 
   "145.64113678268905`", ",", "152.5049920957399`", ",", 
   "159.69233094372566`", ",", "167.21839863596733`", ",", 
   "175.09915897107703`", ",", "183.35132809831748`", ",", 
   "191.992409974795`", ",", "201.04073349370083`", ",", 
   "210.51549136234553`", ",", "220.43678081247526`", ",", 
   "230.82564622918198`", ",", "241.7041237888734`", ",", 
   "253.09528820095875`", ",", "265.02330165239346`", ",", 
   "277.51346505892616`", ",", "290.5922717317271`", ",", "304.287463573256`",
    ",", "318.62808992155533`", ",", "333.6445691677882`", ",", 
   "349.36875327773396`", ",", "365.83399535406716`", ",", 
   "383.0752203827642`", ",", "401.12899931368156`", ",", 
   "420.0336266324466`", ",", "439.82920158818706`", ",", 
   "460.5577132494236`"}], "}"}]], "Output",
 CellChangeTimes->{{3.914668475072554*^9, 3.914668499755843*^9}, 
   3.914668552245121*^9, 3.914668726046682*^9, 3.9146688274830103`*^9, 
   3.914668879178276*^9, 3.914901759760333*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"68c3f65d-5d9d-4ecd-8dfb-9aad21714022"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.004605577132494348`", ",", "0.004822631295685234`", ",", 
   "0.005049914906435707`", ",", "0.005287910063756618`", ",", 
   "0.0055371215872852125`", ",", "0.00579807808807524`", ",", 
   "0.006071333089851971`", ",", "0.00635746620311009`", ",", 
   "0.006657084354545317`", ",", "0.006970823074427396`", ",", 
   "0.007299347844644866`", ",", "0.0076433555102814466`", ",", 
   "0.008003575757717873`", ",", "0.008380772662394453`", ",", 
   "0.008775746309517801`", ",", "0.009189334491148421`", ",", 
   "0.00962241448327028`", ",", "0.010075904906610755`", ",", 
   "0.010550767675158251`", ",", "0.011048010036510847`", ",", 
   "0.011568686708383347`", ",", "0.012113902115805208`", ",", 
   "0.012684812733753825`", ",", "0.013282629540193158`", ",", 
   "0.013908620584720532`", ",", "0.014564113678269208`", ",", 
   "0.015250499209574275`", ",", "0.015969233094372925`", ",", 
   "0.0167218398635971`", ",", "0.01750991589710804`", ",", 
   "0.018335132809832178`", ",", "0.01919924099747994`", ",", 
   "0.020104073349370477`", ",", "0.02105154913623508`", ",", 
   "0.02204367808124802`", ",", "0.02308256462291869`", ",", 
   "0.02417041237888784`", ",", "0.025309528820096405`", ",", 
   "0.02650233016523995`", ",", "0.02775134650589317`", ",", 
   "0.02905922717317333`", ",", "0.030428746357326286`", ",", 
   "0.03186280899215621`", ",", "0.033364456916779694`", ",", 
   "0.03493687532777423`", ",", "0.03658339953540746`", ",", 
   "0.03830752203827725`", ",", "0.04011289993136902`", ",", 
   "0.04200336266324556`", ",", "0.04398292015881966`", ",", 
   "0.04605577132494343`", ",", "0.04822631295685231`", ",", 
   "0.05049914906435715`", ",", "0.05287910063756596`", ",", 
   "0.0553712158728521`", ",", "0.057980780880752425`", ",", 
   "0.06071333089851971`", ",", "0.06357466203110085`", ",", 
   "0.06657084354545328`", ",", "0.06970823074427401`", ",", 
   "0.07299347844644877`", ",", "0.07643355510281435`", ",", 
   "0.08003575757717862`", ",", "0.08380772662394476`", ",", 
   "0.08775746309517807`", ",", "0.09189334491148404`", ",", 
   "0.09622414483270303`", ",", "0.10075904906610722`", ",", 
   "0.10550767675158301`", ",", "0.11048010036510814`", ",", 
   "0.1156868670838338`", ",", "0.12113902115805208`", ",", 
   "0.12684812733753859`", ",", "0.13282629540193192`", ",", 
   "0.13908620584720488`", ",", "0.1456411367826922`", ",", 
   "0.15250499209574286`", ",", "0.15969233094372948`", ",", 
   "0.167218398635971`", ",", "0.17509915897108064`", ",", 
   "0.18335132809832144`", ",", "0.19199240997479983`", ",", 
   "0.20104073349370477`", ",", "0.21051549136235082`", ",", 
   "0.22043678081248075`", ",", "0.2308256462291869`", ",", 
   "0.24170412378887818`", ",", "0.2530952882009645`", ",", 
   "0.2650233016523984`", ",", "0.2775134650589326`", ",", 
   "0.2905922717317342`", ",", "0.30428746357326286`", ",", 
   "0.3186280899215612`", ",", "0.33364456916779694`", ",", 
   "0.3493687532777425`", ",", "0.365833995354075`", ",", 
   "0.3830752203827714`", ",", "0.4011289993136913`", ",", 
   "0.42003362663245625`", ",", "0.4398292015881964`", ",", 
   "0.4605577132494343`", ",", "0.48226312956852446`", ",", 
   "0.5049914906435706`", ",", "0.5287910063756609`", ",", 
   "0.553712158728521`", ",", "0.5798078088075247`", ",", 
   "0.6071333089851976`", ",", "0.6357466203110071`", ",", 
   "0.6657084354545315`", ",", "0.6970823074427415`", ",", 
   "0.7299347844644881`", ",", "0.7643355510281431`", ",", 
   "0.800357575771784`", ",", "0.8380772662394484`", ",", 
   "0.8775746309517807`", ",", "0.9189334491148422`", ",", 
   "0.9622414483270276`", ",", "1.0075904906610766`", ",", 
   "1.0550767675158248`", ",", "1.1048010036510831`", ",", 
   "1.1568686708383353`", ",", "1.2113902115805217`", ",", 
   "1.2684812733753787`", ",", "1.3282629540193227`", ",", 
   "1.3908620584720488`", ",", "1.4564113678269202`", ",", 
   "1.5250499209574286`", ",", "1.5969233094372939`", ",", 
   "1.6721839863597125`", ",", "1.7509915897108073`", ",", 
   "1.8335132809832118`", ",", "1.9199240997479947`", ",", 
   "2.0104073349370495`", ",", "2.1051549136235153`", ",", 
   "2.2043678081248004`", ",", "2.3082564622918653`", ",", 
   "2.417041237888796`", ",", "2.530952882009636`", ",", "2.650233016523991`",
    ",", "2.7751346505893224`", ",", "2.9059227173173383`", ",", 
   "3.042874635732616`", ",", "3.1862808992156175`", ",", 
   "3.336445691677966`", ",", "3.493687532777429`", ",", 
   "3.6583399535407466`", ",", "3.8307522038277284`", ",", 
   "4.011289993136913`", ",", "4.200336266324555`", ",", "4.398292015881964`",
    ",", "4.60557713249429`", ",", "4.822631295685127`", ",", 
   "5.049914906435603`", ",", "5.287910063756499`", ",", "5.537121587285085`",
    ",", "5.79807808807513`", ",", "6.071333089851834`", ",", 
   "6.3574662031099365`", ",", "6.657084354545191`", ",", 
   "6.970823074427244`", ",", "7.2993478446447`", ",", "7.643355510281282`", 
   ",", "8.00357575771767`", ",", "8.380772662394293`", ",", 
   "8.775746309517615`", ",", "9.189334491148202`", ",", "9.622414483270092`",
    ",", "10.075904906610532`", ",", "10.550767675158028`", ",", 
   "11.04801003651059`", ",", "11.56868670838307`", ",", 
   "12.113902115804933`", ",", "12.684812733753517`", ",", 
   "13.282629540192943`", ",", "13.908620584720154`", ",", 
   "14.564113678268882`", ",", "15.250499209573945`", ",", 
   "15.969233094372555`", ",", "16.721839863596756`", ",", 
   "17.509915897107703`", ",", "18.335132809831748`", ",", 
   "19.199240997479535`", ",", "20.104073349370026`", ",", 
   "21.051549136234655`", ",", "22.04367808124755`", ",", "23.0825646229182`",
    ",", "24.170412378887363`", ",", "25.309528820095807`", ",", 
   "26.502330165239414`", ",", "27.75134650589257`", ",", 
   "29.059227173172758`", ",", "30.428746357325622`", ",", 
   "31.862808992155465`", ",", "33.36445691677886`", ",", 
   "34.936875327773464`", ",", "36.58339953540667`", ",", 
   "38.307522038276375`", ",", "40.11289993136813`", ",", 
   "42.003362663244616`", ",", "43.982920158818615`", ",", 
   "46.0557713249425`"}], "}"}]], "Output",
 CellChangeTimes->{{3.914668475072554*^9, 3.914668499755843*^9}, 
   3.914668552245121*^9, 3.914668726046682*^9, 3.9146688274830103`*^9, 
   3.914668879178276*^9, 3.914901759762435*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"b1216877-b1f6-4845-bed8-89e26ebf3765"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["radii"], "Input",
 CellChangeTimes->{{3.914668653597171*^9, 3.914668654973631*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"0fd9702e-c7ac-4ebc-ae67-d917ca8398c0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10.`", ",", "10.471285480508996`", ",", "10.964781961431852`", ",", 
   "11.481536214968829`", ",", "12.02264434617413`", ",", 
   "12.589254117941675`", ",", "13.182567385564074`", ",", 
   "13.803842646028853`", ",", "14.454397707459272`", ",", 
   "15.13561248436208`", ",", "15.848931924611133`", ",", 
   "16.595869074375607`", ",", "17.378008287493753`", ",", 
   "18.197008586099834`", ",", "19.054607179632473`", ",", 
   "19.952623149688797`", ",", "20.892961308540396`", ",", 
   "21.87761623949553`", ",", "22.908676527677724`", ",", "23.9883291901949`",
    ",", "25.118864315095795`", ",", "26.302679918953814`", ",", 
   "27.542287033381662`", ",", "28.84031503126606`", ",", 
   "30.19951720402016`", ",", "31.622776601683793`", ",", 
   "33.11311214825911`", ",", "34.673685045253166`", ",", 
   "36.30780547701014`", ",", "38.018939632056124`", ",", 
   "39.810717055349734`", ",", "41.68693834703355`", ",", 
   "43.65158322401661`", ",", "45.708818961487516`", ",", 
   "47.86300923226385`", ",", "50.11872336272725`", ",", "52.48074602497726`",
    ",", "54.954087385762456`", ",", "57.543993733715695`", ",", 
   "60.25595860743578`", ",", "63.09573444801933`", ",", "66.06934480075961`",
    ",", "69.18309709189363`", ",", "72.44359600749898`", ",", 
   "75.85775750291836`", ",", "79.43282347242814`", ",", "83.17637711026708`",
    ",", "87.09635899560806`", ",", "91.20108393559097`", ",", 
   "95.49925860214358`", ",", "100.`", ",", "104.71285480508996`", ",", 
   "109.64781961431851`", ",", "114.81536214968828`", ",", 
   "120.22644346174131`", ",", "125.89254117941675`", ",", 
   "131.82567385564073`", ",", "138.03842646028852`", ",", 
   "144.5439770745928`", ",", "151.3561248436207`", ",", 
   "158.48931924611142`", ",", "165.95869074375597`", ",", 
   "173.78008287493762`", ",", "181.97008586099827`", ",", 
   "190.54607179632484`", ",", "199.52623149688787`", ",", 
   "208.92961308540407`", ",", "218.77616239495518`", ",", 
   "229.08676527677747`", ",", "239.88329190194898`", ",", 
   "251.18864315095823`", ",", "263.02679918953817`", ",", 
   "275.4228703338166`", ",", "288.40315031266056`", ",", 
   "301.9951720402016`", ",", "316.22776601683796`", ",", 
   "331.1311214825911`", ",", "346.73685045253166`", ",", 
   "363.0780547701014`", ",", "380.1893963205613`", ",", "398.1071705534973`",
    ",", "416.8693834703355`", ",", "436.5158322401661`", ",", 
   "457.0881896148752`", ",", "478.630092322638`", ",", "501.18723362727246`",
    ",", "524.8074602497722`", ",", "549.5408738576248`", ",", 
   "575.4399373371566`", ",", "602.5595860743581`", ",", "630.957344480193`", 
   ",", "660.6934480075964`", ",", "691.8309709189363`", ",", 
   "724.4359600749906`", ",", "758.5775750291835`", ",", "794.3282347242822`",
    ",", "831.7637711026708`", ",", "870.9635899560806`", ",", 
   "912.0108393559096`", ",", "954.992586021436`", ",", "1000.`", ",", 
   "1047.1285480508996`", ",", "1096.4781961431852`", ",", 
   "1148.1536214968828`", ",", "1202.2644346174131`", ",", 
   "1258.9254117941675`", ",", "1318.2567385564075`", ",", 
   "1380.3842646028852`", ",", "1445.439770745928`", ",", 
   "1513.5612484362086`", ",", "1584.893192461114`", ",", 
   "1659.5869074375614`", ",", "1737.8008287493763`", ",", 
   "1819.7008586099844`", ",", "1905.4607179632483`", ",", 
   "1995.262314968881`", ",", "2089.296130854039`", ",", "2187.761623949552`",
    ",", "2290.8676527677726`", ",", "2398.83291901949`", ",", 
   "2511.88643150958`", ",", "2630.2679918953813`", ",", 
   "2754.2287033381663`", ",", "2884.031503126606`", ",", 
   "3019.9517204020162`", ",", "3162.2776601683795`", ",", 
   "3311.311214825911`", ",", "3467.368504525317`", ",", "3630.780547701014`",
    ",", "3801.8939632056126`", ",", "3981.0717055349733`", ",", 
   "4168.693834703355`", ",", "4365.158322401661`", ",", "4570.881896148751`",
    ",", "4786.300923226385`", ",", "5011.872336272725`", ",", 
   "5248.074602497728`", ",", "5495.408738576249`", ",", "5754.399373371572`",
    ",", "6025.5958607435805`", ",", "6309.573444801937`", ",", 
   "6606.934480075957`", ",", "6918.309709189362`", ",", "7244.359600749898`",
    ",", "7585.775750291836`", ",", "7943.282347242814`", ",", 
   "8317.63771102671`", ",", "8709.635899560806`", ",", "9120.108393559096`", 
   ",", "9549.92586021436`", ",", "10000.`"}], "}"}]], "Output",
 CellChangeTimes->{3.9146686553893223`*^9, 3.914901759837591*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"039e703a-1e56-44f5-ae29-c6a89863b2f0"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"calculateIntensitiesLR", "[", 
     RowBox[{
      RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"probabilities", ",", "data"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"probabilities", "=", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"l", "^", "2"}], " ", 
           RowBox[{"r", "^", "4"}], " ", 
           RowBox[{"probfunc", "[", 
            RowBox[{
            "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", ",", 
             "l", ",", "r"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"probabilities", "=", 
        RowBox[{"probabilities", "/", 
         RowBox[{"Total", "[", 
          RowBox[{"Flatten", "[", "probabilities", "]"}], "]"}]}]}], ";", 
       RowBox[{"(*", 
        RowBox[{
        "this", " ", "must", " ", "be", " ", "fixed", " ", "to", " ", 
         "include", " ", "integration", " ", "step", " ", 
         RowBox[{"size", "!!"}]}], "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"data", "=", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Total", "[", "\[IndentingNewLine]", 
            RowBox[{"Table", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"probabilities", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ".", 
               RowBox[{"dataAllLengths", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
              
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"Length", "[", "probabilities", "]"}]}], "}"}]}], 
             "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
          "}"}], "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "data", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"calculateIntensitiesLR2", "[", 
     RowBox[{
      RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"probabilities", ",", "data"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"probabilities", "=", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"l", "^", "2"}], " ", 
           RowBox[{"r", "^", "4"}], "*", "\[IndentingNewLine]", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{
               RowBox[{"Log10", "[", "r", "]"}], "+", 
               RowBox[{"radiusstep", "/", "2"}]}]], "-", 
             SuperscriptBox["10", 
              RowBox[{
               RowBox[{"Log10", "[", "r", "]"}], "-", 
               RowBox[{"radiusstep", "/", "2"}]}]]}], ")"}], "*", 
           "\[IndentingNewLine]", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{
               RowBox[{"Log10", "[", "l", "]"}], "+", 
               RowBox[{"lengthstep", "/", "2"}]}]], "-", 
             SuperscriptBox["10", 
              RowBox[{
               RowBox[{"Log10", "[", "l", "]"}], "-", 
               RowBox[{"lengthstep", "/", "2"}]}]]}], ")"}], "*", 
           "\[IndentingNewLine]", " ", 
           RowBox[{"probfunc", "[", 
            RowBox[{
            "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", ",", 
             "l", ",", "r"}], "]"}]}], "\[IndentingNewLine]", ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"probabilities", "=", 
        RowBox[{"probabilities", "/", 
         RowBox[{"Total", "[", 
          RowBox[{"Flatten", "[", "probabilities", "]"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"data", "=", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Total", "[", "\[IndentingNewLine]", 
            RowBox[{"Table", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"probabilities", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ".", 
               RowBox[{"dataAllLengths", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
              
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"Length", "[", "probabilities", "]"}]}], "}"}]}], 
             "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
          "}"}], "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "data", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"calculateIntensitiesLR3", "[", 
     RowBox[{
      RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"probabilities", ",", "data"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"probabilities", "=", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"probfunc", "[", 
           RowBox[{
           "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", ",", 
            "l", ",", "r"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"probabilities", "=", 
        RowBox[{"probabilities", "/", 
         RowBox[{"Total", "[", 
          RowBox[{"Flatten", "[", "probabilities", "]"}], "]"}]}]}], ";", 
       RowBox[{"(*", 
        RowBox[{
        "this", " ", "must", " ", "be", " ", "fixed", " ", "to", " ", 
         "include", " ", "integration", " ", "step", " ", 
         RowBox[{"size", "!!"}]}], "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"data", "=", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Total", "[", "\[IndentingNewLine]", 
            RowBox[{"Table", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"probabilities", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ".", 
               RowBox[{"dataAllLengths", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
              
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"Length", "[", "probabilities", "]"}]}], "}"}]}], 
             "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
          "}"}], "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "data", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",\

 CellChangeTimes->{{3.914902302663467*^9, 3.914902373944427*^9}, {
  3.914902585643496*^9, 3.914902601766925*^9}, {3.9149026722709093`*^9, 
  3.914902680402082*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"bf4a0fb8-480a-417d-9fe3-28875e163314"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"calculateIntensitiesLR3", "[", 
       RowBox[{"1.89", ",", "0.769", ",", "5.65", ",", "0.782"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{"1.89", ",", "0.769", ",", "5.65", ",", "0.782"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"calculateIntensitiesLR2", "[", 
       RowBox[{"1.89", ",", "0.769", ",", "5.65", ",", "0.782"}], "]"}]}], 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{",", "\[IndentingNewLine]", 
       RowBox[{"intPolydisp", "[", 
        RowBox[{
         RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", "qlist", ",", 
         RowBox[{"10", "^", 
          RowBox[{"-", "3.3"}]}]}], "]"}]}], "*)"}], "\[IndentingNewLine]", 
     "}"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR3", "[", 
       RowBox[{"1.89", ",", "0.769", ",", "5.65", ",", "0.782"}], "]"}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{"1.89", ",", "0.769", ",", "5.65", ",", "0.782"}], "]"}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR2", "[", 
       RowBox[{"1.89", ",", "0.769", ",", "5.65", ",", "0.782"}], "]"}], 
      "]"}]}], "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{",", "\[IndentingNewLine]", 
      RowBox[{"slope", "[", 
       RowBox[{"intPolydisp", "[", 
        RowBox[{
         RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", "qlist", ",", 
         RowBox[{"10", "^", 
          RowBox[{"-", "3.3"}]}]}], "]"}], "]"}]}], "*)"}], 
    "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"FrameLabel", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
     "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"LabelStyle", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
     "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9149024448266706`*^9, 3.914902453753046*^9}, {
  3.9149025580164003`*^9, 3.914902561065536*^9}, {3.9149026071693907`*^9, 
  3.9149026213369493`*^9}, {3.914902688378051*^9, 3.914902756612199*^9}, {
  3.9149126381092043`*^9, 3.9149126693919907`*^9}, {3.914912793007593*^9, 
  3.914912830273576*^9}, {3.9149128629289513`*^9, 3.914912873512375*^9}, {
  3.9149129548215847`*^9, 3.91491303216957*^9}, {3.91491307276647*^9, 
  3.9149130735787992`*^9}},ExpressionUUID->"94902dfa-4614-4ed1-977d-\
68614d987744"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], LineBox[CompressedData["

1:eJw1lgs0VHkcx4cY79eYMWbGa2aQkEeRlLoSq9rWIyWliKKSSrWqlRZFKykk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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], LineBox[CompressedData["

1:eJw1lgtYjGkfxqfTTOemOTQ1U1NTzehA53PxtosNiyK+cozUWuXUqs0pYnNs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      "]]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], LineBox[CompressedData["

1:eJw1lgtYTGkDx6eL7qmZZppmpqamaTISme4XOWPJJbcUQhRJ7ZKSat1atHLX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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-7.295517004712037, -29.914870696805604`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"Intensity [a.u.]\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", TraditionalForm], None}},
  
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-25.328436022934504`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
          TraditionalForm], {0.01, 0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.01\"", ShowStringCharacters -> False], 0.01, 
           AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-32.23619130191664, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-29.933606208922594`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-27.631021115928547`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-23.025850929940457`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-20.72326583694641, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-25.328436022934504`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-32.23619130191664, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-29.933606208922594`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-27.631021115928547`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-23.025850929940457`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-20.72326583694641, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}}, {{{-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 0.01, 
           AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 0.1, 
           AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{563.9351501464844, Automatic},
  LabelStyle->{FontSize -> 18, 
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-7.295517004712037, 
   2.302585092994046}, {-29.914870696805604`, -0.012750761732003735`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}], 
    Charting`ScaledTicks[{Log, Exp}]}]], "Output",
 CellChangeTimes->{
  3.914902456423452*^9, 3.9149025617748737`*^9, 3.914902625259129*^9, {
   3.9149027057353477`*^9, 3.914902759472698*^9}, {3.914912654457328*^9, 
   3.9149126711891127`*^9}, 3.9149128348441343`*^9, 3.914912875264328*^9, 
   3.914912973681933*^9, {3.9149130091918697`*^9, 3.914913034428952*^9}},
 CellLabel->
  "Out[124]=",ExpressionUUID->"5dac7d72-af6d-47e4-ad1c-8efc95ca5bbf"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], LineBox[CompressedData["

1:eJw1lXk4VesXx4/pcIzbzFEixC3qZnbRVtxmIiRDKZ2KVJQGGTJWKBqQRJLm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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], LineBox[CompressedData["

1:eJw1VXk4VdsbPg4Ox7jNHEMpU9HVFQmxT2miZM4YEkXDVeEmmZNkSAPKPFSa
Lq4ypGR9qVSiFB0SIhQpMxnOcX779+zrj/3s53ve9a21vu9733epegfY+VIp
FMor4vv/n6LTFTNzXhG87/MFaaz5jiD2pONbV0W4Z8GtdZYaRFFdElpF2oog
90WH84o9iPD1/8yHsxngvoK6w2doCHEvbGtybGKA7M+ZAPqnHwh978lbk8uA
HqNVF4+8GUYRzNMn+AMYMFJZUaUOP5FZhszWLpwBjZXnXHorf6HF8VK5CowB
NpLb3/5dOoJqLS1/JPUqwBPTfP3aO6Mo4np/jc99BfDYxb1YYjeGTNkRKRvP
KIDFD3bDWPMYWnRQ8JZ2UIAgtZ37zliPo9riB/o/1RQgoD8q3ebtOAqn7RZ4
Pi0PndyqT5pWE8jUc/BTVr08oIQm6rs3E4hTFfNP4FV5uJOJb19lOYmeYMqR
O/3kYTzJWkLy1SQK86+yXWkkD5XyBQI7t06hjXW2agt0eZiwanpf9nQKsRk/
Zz50yMG1r+eMl5lOo5rAuNd378nB+SNb7u+pmkZhjcuzY8LkIPxmernx2hlk
ov74L1crORjaonsz9dYMWgh33KSnIgei5woCjZV/o8esUSmhUVkIveHiR730
G4XqJnzrRbJggSrePqbOIuN4terqi7LAKb8Km07Movme2sRL+2ShQ75L+MCX
WfTIyMXDX08WBjsEZ6iWcyj08uTaTbyyUPa8dWKibA4ZDSfzKrTKQK1MuYmo
3DyaM9dijd2QgWOCV7YYnJpHD7Prbr8KlgGV2Wr97e3zKGTa/XT+NhmQXBee
qa6/gDbs/m0VIicDQqHfqNVJC2i26NJym0FpGPmU3jrUu4AecrUnNaulIeR8
TcH1dWwU4lz/gnteGsTVKiXaotloQ5nXtTZXadind0HkVCMbzdIXDpVqS8Nu
lot7jBQHPfROMz3HlgLT5oTp0T0cFPJYF/NskoL9+eJmz9I5yFC64ev6XCnQ
bf5XjdrCQb+P+FSIBUiB1CErgSrhRVT1YvHcN1wKcp+qRo0xF9HfKhmutZgU
CIbylz49sYjWn1y3Jr1XEqKszk1tLlhEM++auEfvS4KfvyX/xcZFVKnl92Hr
GUlwlFRZ9XJqEQVHU28qO0iCCf8zfVEGFxl0ZJ+cVpOE7aP9nXEbuWhaz9Cy
aVoC5r1X93u4c1F54nulm/USIPY1fhuc4qKg/sOjYVclwLedOdqeykX6prQ6
Bz8J4IpE9rUXc9FUWn6qjpEEiBsGrRh/TuSPGB/kE5IAeuDxK/YdRP72j0ad
HRgkHjGt1Bsh8vMDRMrvYcATaxbpRaHA5Cz9S2IYBiN9p3fK0ynwwPZG2X4r
DHafrqa5SlAg8K5ZrIkKBpYVOT2mChQ4QLtfrNEtDk51lww6l1Ogv+qbHStS
HMZHIr12aVHAx19x9qyqOCjjyRo3dQmcYZNj8EwMBvov5LLXU2B/Y+zmAR8x
sPA30/Qzo8DX8OrvqTQxYPG/PMbeSgFv3ZGkLbdFYfseH+UmKwLvWaE3ZSEK
+Kxw8C9HAr/s1HZ9WAQMQiLeB3gQuHlSmH2yCOi+5Az7HqTAvmlQ5dUVgXyP
5OmeYxToKZquv98sDL1qKcfGQyng5bz6iPcJYdhKawq5dZbA6Z4SktLCEL15
9JrkJQp4Pr5S+bRCCM6hPymbcyjQfeSV23EnIUhTLQjfcpcCHiociuocHZSM
apO1HhL4uz+LmjPpMN323ZFdTwH36AM7ozbSYbLB40ETiwKdelljut2CoCHD
sbj7ncD736V9iRSEn/H3fPPmCDyNzyRFVRBevd3PeCTCA+7bjXrMnglA3+7T
6wRUeaBz9ujZER8BMH428ueV9TzgdrdwdS5NAHa94Nt2yIoHOtza3lndpsGA
w90N13x5wFVUJJhjQYPOgpQorUgCr2Uyiof5AdVuWamRyQMux4KRezI/TB2Y
ys6q5IF21bs+Irr8cLZ3z8LlVh5wbumm1zTzQeFCzAOZKR5oi5UqPXyCDzKP
L7umI0MF5/U7HBSl+cAxm/XliyEV2r+HzTVU8EKgLY3f0J0KThlluaFOvMCZ
V4QNMVRgWX4zXz1HhbEdRZThO1TYw2YMfcqkwnJW3KBdCxU+FltfOL+RCoyE
jJKgRSo4esauM+rmgbpvObfstXmhFatuHyTqKOGXM51w4QWHul/h14i+1PsO
s2wTeKElcMXKHc8oYGuy8P1EDS/Yqzu9+u1DAeVt1Z8dxnjhAyvx6C0aBfDS
BakZdT64gUWrl9hwUY4tvc9+L1Fn4I8A0dRF9Dr/Y9yhdD7IZ9k/OtLGQbFZ
weYG74nY6AlfI4ODjGoS+EpE+SE/W8Na24ONsnK1Pjbt5IdcbkpGQsEC0jTp
j05K5Icc77m+of55dCkntqKnkR+yX3j/YaE1j1IWnceROA1ytBpDbh+eQzNd
/vEqDjTITTR4JlA6i2ieUxmjGUQ8kit6cOI3ms67LqDeS4NsW0HneoPf6Kqz
WHDpKgHILj9eqH5qBqXHe5hEBApAptznn7E10+gl58G+yFoByAjdYtjPnUIO
7Ucv5wkJwrWu4mhz8ylk482SbHAiYqZcY2HcJLptXFA+eFMQ0q9HyVIbJlD7
bfxl35QgpNJ+eO0TnUC7V24TK9xCh1R/+3tgM45KDOqLBdPocLmxZnpZ6hhy
sVDSXBigg5rnrqjFklGU/ChFw81QCFaoL5N5YjCCFBZrSgTPC8Hy4fE7p2t+
oriih096O4RAuey5mbH5MCrb9TGuTkcYFE9ebZl9PYTqu710zkYIg7zpIb8q
m0G0ujZiiIfQrTyvKSe47RsSz3lcI6YqArKvxS/rewwg0Rv5EHlcBKRSvmpM
9vehjKGDwxpPRQBzrHhcdvgrytRkr2oVFwUxxXibYxM9KP6zW7rjXlFg1FU0
7J3oRnrqpWtP3hGF5bvdpjq4n9GYWvVZ3ilRWNFBUXEW/YTcLwvGP9soBsoH
irZ/ZLBQQsnxyYgzYqA0sfO4nVYL+vz2TR77pRjIRoxnvjNoRhEaoV+pQuKg
Kf3H+Yy4BlTst0/I2UIcVHROdV4peI5SlwvO1p0Vh1Xx8Z5Kp54gpfxfL4SR
OMg9VKFJlJahTW/0rrGnxGFZfst92dSriGriZVomhYEUGeOR993UBLQxkCbX
443W1z8cYmKgTe6HnxvrHn9tjy2dh4/9iE6W8cVAi7wPblAnErk5CAM58r64
0r8fjCyjMVAk68F7c2/1r04i8sl68TqvHN3BVAxWkv3ADbWzhhKyMNAk+4Xr
71+dopqPgQ7ZT9wpiWkOhRgokP3GlVySJqOuY8Ag54EXbzzUG0PgSuS8cO8D
A3VDecR55Dxx4Wbq2S5i/+XkvPE05fcuiekYLCP5gBdif08su0jsR/IFz3N8
fe9NPJFP8gl/ytFzRlEYqJJ8w5PNdOa1Q7AlPuJsj1t2zAAM1Em+4sG/WmpX
HcDgCsln3MnDWkxqL7bEd/yFdYzFCgcM0kg94OEXGlmhO7ElveCTf3WeMDbH
lvSEx3GOzIWaYEt6w68m0+1s9THIJPWI53V0NDetwZb0ilvn/bWDrYlBFqln
nOlmIjOwAlvSOx5p/uZ5IvHu/ucHuEZQnOYEA1vyC5xi08OSkccgn/QT/Kir
3bJJGSIm/Qav7z11LFYag0LSj/DPY/vU6gg+FZJ+hTNTXUavE/EN0s/wqH9z
JVWJ9TdIv8MtC/VM1hL7FZF+iP+y++fmS1kCJ/0S12U2xXQR5//np3iQr7qO
nyK25LdM+QLV7r3E/e1IP2bORlu3lqti0Er6NTO373PwfnVsyc+ZYWl7BzxX
YUt+zzx4y/9zHtEvB/I9YEpzLE/K62HAIt8LZpZrynDtegz+ByQRVzI=
      "]]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], LineBox[CompressedData["

1:eJw9VXk8lGsbnjFjJvvLjG0mNJaQioRS8Sq0SSGylkIkqaRI2amUpM0up0PH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      "]]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], LineBox[CompressedData["

1:eJw9VWk4Vl0bPeaZY+aReSxKb6aEztNrSCoJlVQIoRAloSRKaUTGyEzxiqRS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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-7.2705523451534475`, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"Slope\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", TraditionalForm], None}},
  
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{Automatic, Automatic}, {
      Charting`ScaledTicks[{Log, Exp}], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{
     Automatic, Automatic}, {{{-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 0.01, 
           AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 0.1, 
           AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{563.9351501464844, Automatic},
  LabelStyle->{FontSize -> 18, 
    GrayLevel[0]},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-7.2705523451534475`, 
    2.2795592420641055`}, {-4.160294964439957, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}], Automatic}]], "Output",
 CellChangeTimes->{
  3.914902456423452*^9, 3.9149025617748737`*^9, 3.914902625259129*^9, {
   3.9149027057353477`*^9, 3.914902759472698*^9}, {3.914912654457328*^9, 
   3.9149126711891127`*^9}, 3.9149128348441343`*^9, 3.914912875264328*^9, 
   3.914912973681933*^9, {3.9149130091918697`*^9, 3.9149130362849894`*^9}},
 CellLabel->
  "Out[125]=",ExpressionUUID->"c0061985-47c3-4261-a5db-4cafa1977112"]
}, Open  ]]
},
WindowSize->{1216, 911},
WindowMargins->{{-1320, Automatic}, {Automatic, 35}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"788a7c61-7a90-4448-8d55-2f605065d49f"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 918, 24, 53, "Input",ExpressionUUID->"ed8a0803-0b0b-4290-9619-cc4a7cd89108"],
Cell[1501, 48, 4761, 77, 245, "Output",ExpressionUUID->"68c3f65d-5d9d-4ecd-8dfb-9aad21714022"],
Cell[6265, 127, 6410, 104, 329, "Output",ExpressionUUID->"b1216877-b1f6-4845-bed8-89e26ebf3765"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12712, 236, 176, 2, 30, "Input",ExpressionUUID->"0fd9702e-c7ac-4ebc-ae67-d917ca8398c0"],
Cell[12891, 240, 4552, 71, 224, "Output",ExpressionUUID->"039e703a-1e56-44f5-ae29-c6a89863b2f0"]
}, Open  ]],
Cell[17458, 314, 8453, 206, 1261, "Input",ExpressionUUID->"bf4a0fb8-480a-417d-9fe3-28875e163314"],
Cell[CellGroupData[{
Cell[25936, 524, 4412, 97, 715, "Input",ExpressionUUID->"94902dfa-4614-4ed1-977d-68614d987744"],
Cell[30351, 623, 32343, 704, 377, "Output",ExpressionUUID->"5dac7d72-af6d-47e4-ad1c-8efc95ca5bbf"],
Cell[62697, 1329, 32043, 660, 392, "Output",ExpressionUUID->"c0061985-47c3-4261-a5db-4cafa1977112"]
}, Open  ]]
}
]
*)

